'''
Created on May 07 2014
Edited on November 12 2015

@author: Mengxue CAO
'''

from __future__ import division
import functions
import gsom_grow

##########################
# gloabal parameters
##########################

PATH = '/Users/mengxuecao/Codes/GSOM/bernd'

# testing data
AUDIO_TESTING_DATA = PATH+'/training_data/audio_coding_1'

# output MSE (Mean Squared Error) file
MSE_FILE_A = PATH+'/gmaps/check/MSE_A'

# distance measurements: 'euclidean' OR 'cosine'
MEASURE_A = 'euclidean'

# store MSE results of each check round
MSE_all_a = []

# read in audio testing data
testing_data_a = gsom_grow.read_data(AUDIO_TESTING_DATA)

# define number of checking phases
EPOCH_checking = 15

for n in range(EPOCH_checking):
	print '\n### epoch: ', n+1, '###'

	##########################
	# input and output files
	##########################

	# input trained gmap file
	GMAP_FILE_A = PATH + '/gmaps/gmap_training_a_' + str(n+1)

	# output matlab files
	CHECK_LABLE_MATLAB_FILE_A = PATH+'/matlab/check/gmap_l_a_' + str(n+1)
	CHECK_DISTANCE_MATLAB_FILE_A = PATH+'/matlab/check/gmap_d_a_' + str(n+1)
	CHECK_DISTANCE_MEAN_MATLAB_FILE_A = PATH+'/matlab/check/gmap_d_mean_a_' + str(n+1)

	# read in gmaps
	gmap_a = functions.read_gmap(GMAP_FILE_A)

	##################################
	# check A-Map
	##################################
	print 'checking A-Map: ', n+1

	error_n_a = 0	# set error counts

	for i in range(len(testing_data_a)):

		token_a = testing_data_a[i]		# token for audio testing data

		# testing data for A
		testing_vector_a_char = []						# list container for testing vectors of A in char
		testing_vector_a_float = []						# list container for testing vectors of A in float
		testing_vector_a_char = token_a[0:-1]			# get testing vectors of A
		testing_lable_a = token_a[-1]					# get lable of A

		# convert the vector from string to float
		for k in range(len(testing_vector_a_char)):		
			testing_vector_a_float.append(float(testing_vector_a_char[k]))

		# find Winner and get the Winner representation
		gmap_a_info = functions.find_winner(gmap_a, testing_vector_a_float, testing_lable_a, MEASURE_A)

		gmap_a = gmap_a_info[0]
		error_i_a = gmap_a_info[1]			# get error of current token
		error_n_a = error_n_a + error_i_a	# store error for each token

	gmap_a = functions.reorder(gmap_a)		# reorder the gamp by error distance

	MSE_a = functions.calculate_mse(error_n_a, len(testing_data_a))		# calculate MSE
	MSE_all_a.append(MSE_a)		# record MSE for each checking round

	print 'MSE a: ', MSE_a

	####################################
	# write files
	####################################
	functions.write_check_gmap_lable_matlab(gmap_a, CHECK_LABLE_MATLAB_FILE_A)					# write label of each node into matlab file
	functions.write_check_distance_gmap_matlab(gmap_a, CHECK_DISTANCE_MATLAB_FILE_A)			# write the error distance of each node into matlab file
	functions.write_check_distance_mean_gmap_matlab(gmap_a, CHECK_DISTANCE_MEAN_MATLAB_FILE_A)	# write the mean error distance of each node  into matlab file

############################################################################################################
# write MSE file
functions.write_item(MSE_all_a, MSE_FILE_A)
