'''
Created on May 09 2013
Edited on November 12 2015

@author: Mengxue CAO
'''

from __future__ import division  
import math
import functions


####################################
# read in the training data
####################################
def read_data(training_data):
	# read in training data	
	s_training_data = functions.read_file(training_data)
	l_training_data = s_training_data.split('\n')		# split the string into list by '\n'
	l_training_data.remove(l_training_data[0])			# remove head information
	l_training_data.remove(l_training_data[-1])			# remove '' at the end
	
	for i in range(len(l_training_data)):				# split the string in the list into list by '\t'
		l_training_data[i] = l_training_data[i].split('\t')	

	return l_training_data


####################################
# find the BMU by calculating 
# the Euclidean discatnce
####################################
def find_bmu(gmap, training_vector, GT, measure):
	print '\n######## find bmu ########'

	measure_distance = []		# initialize list container for caculation results

	# caculate distance between the input token and every node in the gmap
	if measure == 'euclidean':
		for i in range(len(gmap)):	
			distance = functions.calculate_euclidean_distance(training_vector, gmap[i]['weight_vector']) # calculate euclidean distance
			measure_distance.append(distance)
	elif measure == 'cosine':
		for i in range(len(gmap)):	
			distance = functions.calculate_cosine_distance(training_vector, gmap[i]['weight_vector']) # calculate euclidean distance
			measure_distance.append(distance)
	elif measure == 'both':
		for i in range(len(gmap)):	
			distance_1 = functions.calculate_euclidean_distance(training_vector[:-10], gmap[i]['weight_vector'][:-10]) # calculate distance by euclidean
			distance_2 = functions.calculate_cosine_distance(training_vector[-10:], gmap[i]['weight_vector'][-10:]) # calculate distance by cosine
			distance = distance_1 + distance_2
			measure_distance.append(distance)


	####################################
	# if min distance is more than one node, the function take the first node that is growable
	####################################

	distance_buff = []		# list container for distance information [[distance, index],[],[]...]
	for i in range(len(measure_distance)):
		distance_buff.append([measure_distance[i],i])

	distance_buff.sort()	# sort the list by distance, while keeping track of thier original index

	bmu_buff = []
	bmu_buff.append(distance_buff[0])		# list container for best bmus (in case that more than one bmus have the same distance)

	for i in range(1, len(distance_buff)):
		if distance_buff[i][0] == distance_buff[0][0]:	# find the best bmus with same distance
			bmu_buff.append(distance_buff[i])

	# if only one bmu exists, then use this bmu
	if len(bmu_buff) == 1:
		bmu_index = bmu_buff[0][1]						# get the node index of bmu
		bmu = gmap[bmu_index]							# get bmu representations

	# if more than on bmu have the same distance, then check whether there is a growable bmu
	else:
		bmu_growable = 0 								# set marker for bmu growable check

		# if one of the bmu is growable (boundary node), then choose the first one as bmu
		for i in range(len(bmu_buff)):
			print 'bmu_index: ', bmu_buff[i][1], 'is_boundary: ', gmap[bmu_buff[i][1]]['is_boundary']	

			if gmap[bmu_buff[i][1]]['is_boundary'] == 1:
				bmu_index = bmu_buff[i][1]				# get the node index of bmu
				bmu = gmap[bmu_index]					# get bmu representations

				# move the bmu item to the first position of the distance_buff list
				distance_buff_first_item = distance_buff[0]
				distance_buff_best_bmu = distance_buff[i]

				# exchange the first item with the best bmu
				distance_buff[0] = distance_buff_best_bmu 
				distance_buff[i] = distance_buff_first_item

				bmu_growable = 1 						# update the growable marker
				break									# stop the process
				
		# if no bmu is growable, then choose the first one as bmu
		if bmu_growable == 0:							
			bmu_index = bmu_buff[0][1]					# get the node index of bmu
			bmu = gmap[bmu_index]						# get bmu representations


	error_distance = distance_buff[0][0]				# get error distance for bmu


	########################
	# update bmu information
	########################

	# accumulate error value
	error = bmu['error_value'] + error_distance
	
	# count hits
	bmu['hits'] = bmu['hits'] + 1

	# update error value of the bmu, if grow, mark as is_grow
	if error <= GT:
		bmu['error_value'] = error
	else:
		bmu['is_grow'] = 1
		bmu['error_value'] = GT/2
	
	bmu_info = [bmu, bmu_index, distance_buff]	# return bmu information: 
												# (1) bmu representation
												# (2) bmu index
												# (3) distance information of all nodes: [[distance, index],...]
	return bmu_info


####################################
# find the BMU by calculating 
# the Euclidean discatnce
# no error distribution, no neighbourgh
####################################
def find_bmu_WTA(gmap, training_vector, error, measure):
	print '\n######## find bmu WTA ########'

	measure_distance = []		# initialize list container for caculation results

	# caculate distance between the input token and every node in the gmap
	if measure == 'euclidean':
		for i in range(len(gmap)):	
			distance = functions.calculate_euclidean_distance(training_vector, gmap[i]['weight_vector']) # calculate distance
			measure_distance.append(distance)
	elif measure == 'cosine':
		for i in range(len(gmap)):	
			distance = functions.calculate_cosine_distance(training_vector, gmap[i]['weight_vector']) # calculate distance
			measure_distance.append(distance)
	elif measure == 'both':
		for i in range(len(gmap)):	
			distance_1 = functions.calculate_euclidean_distance(training_vector[:-10], gmap[i]['weight_vector'][:-10]) # calculate distance by euclidean
			distance_2 = functions.calculate_cosine_distance(training_vector[-10:], gmap[i]['weight_vector'][-10:]) # calculate distance by cosine
			distance = distance_1 + distance_2
			measure_distance.append(distance)

	distance_buff = []		# list container for distance information [[distance, index],[],[]...]
	for i in range(len(measure_distance)):
		distance_buff.append([measure_distance[i],i])

	distance_buff.sort()	# sort the list by distance, while keeping track of thier original index
	print distance_buff

	bmu_index = distance_buff[0][1]						# get the node index of bmu
	bmu = gmap[bmu_index]							# get bmu representations

	error_distance = distance_buff[0][0]				# get error distance for bmu

	# record max error value
	error_max = max(error, error_distance)
	
	bmu_info = [bmu, bmu_index, distance_buff, error_max]	# return bmu information: 
															# (1) bmu representation
															# (2) bmu index
															# (3) distance information of all nodes: [[distance, index],...]
															# (4) max error
	return bmu_info


####################################
# calculate the learning rate by
# using the function:
# LR(t+1) = ALPHA * u(n) * LR(t)
####################################	
def calculate_learning_rate(gmap, LR):
	ALPHA = 0.9	# learning rate reduction
	R = 3.8		# parameter for learning rate function with number of nodes

	N = len(gmap)
	f_N = 1 - R/N	# Learning rate is in related to the number of nodes in the map

	LR = ALPHA * f_N * LR	# calculate learning rate

	return LR

####################################
# calculate the neighbourhood size
####################################
def calculate_neighbourhood_size(NS):
	ALPHA = 0.9	# neighbourhood reduction	
	NS = NS * ALPHA
	
	return NS

####################################
# cover neighnourhood mask
####################################
def neighbourhood_function(NS, distance):
	h_t = math.e**(-(distance**2)/(2*(NS**2)))	# gaussian function
	
	return h_t


####################################
# update the weight vectors for BMU
####################################
def weight_update(gmap, training_vector, bmu, GT, LR, NS):
	print '######## weight update ########'
	print bmu[0]['position'], 'is_grow: ', bmu[0]['is_grow'], 'is_boundary: ', bmu[0]['is_boundary']
	
	# weight update only
	if bmu[0]['is_grow'] == 0:		
		for i in range(len(gmap)):
			# calculate node distance from BMU
			distance = functions.calculate_euclidean_distance(bmu[0]['position'], gmap[i]['position']) 
			if distance <= NS:  # if node in neighbourhood of BMU
				for j in range(len(gmap[i]['weight_vector'])):					# update weight vector
					gmap[i]['weight_vector'][j] = gmap[i]['weight_vector'][j] +\
								      			  LR * (training_vector[j] - gmap[i]['weight_vector'][j]) *\
								     			  neighbourhood_function(NS, distance)
					if gmap[i]['weight_vector'][j]>1:
						gmap[i]['weight_vector'][j]=1
					if gmap[i]['weight_vector'][j]<0:
						gmap[i]['weight_vector'][j]=0

	# error distribution
	elif bmu[0]['is_boundary'] == 0:	
		print '######## error distribution ########'
		print bmu[0]['position'], 'error_value: ', bmu[0]['error_value'], 'is_grow: ',bmu[0]['is_grow'], 'is_boundary: ', bmu[0]['is_boundary']
		
		# readuce the error of bmu
		gmap[bmu[1]]['error_value'] = gmap[bmu[1]]['error_value'] / 2	# error distribution
		gmap[bmu[1]]['is_grow'] = 0		# change grow status

		# update the error value of direct neighbors
		n_direct_neighbobr = 0
		direct_neighbobr_index = []
		for i in range(len(gmap)):
			# calculate the number of direct neighbors
			distance = functions.calculate_euclidean_distance(bmu[0]['position'], gmap[i]['position']) 
			if distance == 1:  # if the node is direct neighbour
				n_direct_neighbobr = n_direct_neighbobr + 1
				direct_neighbobr_index.append(i)

		if n_direct_neighbobr != 0:
			# update the error value of direct neighbors
			print 'number of direct neighbors: ', n_direct_neighbobr
			for i in range(len(direct_neighbobr_index)):
				print 'direct neighbor position: ', gmap[direct_neighbobr_index[i]]['position']
				gmap[direct_neighbobr_index[i]]['error_value'] = gmap[direct_neighbobr_index[i]]['error_value'] + (bmu[0]['error_value']) / 2 / n_direct_neighbobr	# error distribution
		else:
			print '#####################\nERROR: cannot do error distribution, no neighbors of the bmu found!\n#####################\n'	

	return gmap

####################################
# update the weight vectors for BMU
# Winner Take ALL
####################################
def weight_update_WTA(gmap, training_vector, bmu, LR):
	print '######## weight update WTA ########'
	print bmu[0]['position'], 'is_grow: ', bmu[0]['is_grow'], 'is_boundary: ', bmu[0]['is_boundary']

			
	for i in range(len(gmap)):
		# calculate the number of direct neighbors
		distance = functions.calculate_euclidean_distance(bmu[0]['position'], gmap[i]['position']) 
		if distance <= 1:  # if the node is direct neighbour
			for j in range(len(gmap[i]['weight_vector'])):					# update weight vector
				gmap[i]['weight_vector'][j] = gmap[i]['weight_vector'][j] +\
							     			  LR * (training_vector[j] - gmap[i]['weight_vector'][j]) *\
							     			  neighbourhood_function(1, distance)
				if gmap[i]['weight_vector'][j]>1:
					gmap[i]['weight_vector'][j]=1
				if gmap[i]['weight_vector'][j]<0:
					gmap[i]['weight_vector'][j]=0
			
	return gmap


################################################# 
# Find the most reasonable growing direction
#################################################
def select_growing_direction(available_position, taken_position):
	print '######## select growing direction ########'

	# list container for distance measurements
	# [
	#  [[distance_node1_bmu1, node_position1], [distance_node2_bmu1, node_position2], ...], 
	#  [[distance_node1_bmu2, node_position1], [distance_node2_bmu2, node_position2], ...],
	#  ...
	# ]
	new_node_and_bmu_ditance_buff = []	

	# calculate the position distance between each new node position and each bmu
	# (taken_position was sorted by bmu ranking)
	for i in range(len(taken_position)):
		# list container for the distance measure between all avalibale nodes and a specific bmu node
		# [[distance_node1, node_position1], [distance_node2, node_position2], ...]
		new_node_and_bmu_ditance = []

		# get the distance between each available position and a selected bmu
		for j in range(len(available_position)):
			new_node_and_bmu_ditance.append([functions.calculate_euclidean_distance(taken_position[i], available_position[j]),available_position[j]])
		# append the distance between each available position and the bmus to the buffer
		new_node_and_bmu_ditance_buff.append(new_node_and_bmu_ditance)

	# find the most reasonable node
	for i in range(len(new_node_and_bmu_ditance_buff)):		# for each bmu
		print '# BMU: ', i + 1, ' #'

		# list container for  new_node_and_bmu_ditance_buff
		new_node_and_bmu_ditance_buff_checked = []

		# only keep nodes that are within the available position list
		for j in range(len(new_node_and_bmu_ditance_buff[i])):
			if new_node_and_bmu_ditance_buff[i][j][1] in available_position:
				new_node_and_bmu_ditance_buff_checked.append(new_node_and_bmu_ditance_buff[i][j])

		print '#### existance-checked new node and bmu ditance buffer ####', new_node_and_bmu_ditance_buff_checked

		# remove nodes with maximum distance
		while max(new_node_and_bmu_ditance_buff_checked)[0] != min(new_node_and_bmu_ditance_buff_checked)[0]:
			print '#### available position before readuce ####', available_position
			print '#### remove: ', max(new_node_and_bmu_ditance_buff_checked)[1]
			
			available_position.remove(max(new_node_and_bmu_ditance_buff_checked)[1])
			new_node_and_bmu_ditance_buff_checked.remove(max(new_node_and_bmu_ditance_buff_checked))

		print '#### available position after readuce ####', available_position

		# if the candidate list only has one node at last, then chose the node as new node
		if len(available_position) == 1:
			new_node_position = available_position[0]
			break	# exit the 'for' loop

	return new_node_position


####################################
# Grow new nodes
####################################
def grow_nodes(gmap, training_vector, bmu):
	print '\n######## grow new nodes ########'
	print 'grow bmu: ', bmu[0]['position'], 'error_value: ', bmu[0]['error_value'], 'is_grow: ',bmu[0]['is_grow'], 'is_boundary: ', bmu[0]['is_boundary']
	possible_position=[]

	# list all 4 posible positions
	position_0 = [bmu[0]['position'][0] - 1, bmu[0]['position'][1]]	# [x-1, y]
	position_1 = [bmu[0]['position'][0] + 1, bmu[0]['position'][1]]	# [x+1, y]
	position_2 = [bmu[0]['position'][0], bmu[0]['position'][1] - 1]	# [x, y-1]
	position_3 = [bmu[0]['position'][0], bmu[0]['position'][1] + 1]	# [x, y+1]
		
	possible_position = [position_0, position_1, position_2, position_3]
	print 'possible position: ', possible_position

	# check if they are available
	taken_position = []	# list container for all taken positions
	for i in range(len(bmu[2])):	# get taken positions (sorted by bmu closeness)
		taken_position.append(gmap[bmu[2][i][1]]['position'])
	print 'taken position: ', taken_position

	available_position = []	# container for recording the available positions for growing new nodes
	for i in range(len(possible_position)):
		if possible_position[i] not in taken_position:		# if available, select possible positions
			available_position.append(possible_position[i])	# record the available positions for growing new nodes
	print 'available position: ', available_position

	################################################# 
	# find the most reasonable growing direction
	#################################################

	# if only one node is available, take this node as the new node position
	if len(available_position) == 1:
		new_node_position = available_position[0]
	else:
		new_node_position = select_growing_direction(available_position, taken_position)
	print 'new node position: ', new_node_position

	# change bmu property
	gmap[bmu[1]]['is_grow'] = 0				# mark bmu as non-grow
	#print 'updated bmu', gmap[bmu[1]]
	
	# weight initialization
	
	#################################################
	# 	list all possible neighbor positions	
	#   * represents the new node to be added
	#################################################
	#			8			#
	#		9	4	10		#
	#	5	1	*	2	6	#
	#		11	3	12		#
	#			7			#
	#################################################
	neighbor_position_1 = [new_node_position[0] - 1, new_node_position[1]]		# x-1
	neighbor_position_2 = [new_node_position[0] + 1, new_node_position[1]]		# x+1
	neighbor_position_3 = [new_node_position[0], new_node_position[1] - 1]		# y-1
	neighbor_position_4 = [new_node_position[0], new_node_position[1] + 1] 		# y+1			
	neighbor_position_5 = [new_node_position[0] - 2, new_node_position[1]]		# x-2
	neighbor_position_6 = [new_node_position[0] + 2, new_node_position[1]]		# x+2
	neighbor_position_7 = [new_node_position[0], new_node_position[1] - 2]		# y-2
	neighbor_position_8 = [new_node_position[0], new_node_position[1] + 2]		# y+2
	neighbor_position_9 = [new_node_position[0] - 1, new_node_position[1] + 1] 	# x-1, y+1
	neighbor_position_10 = [new_node_position[0] + 1, new_node_position[1] + 1] 	# x+1, y+1
	neighbor_position_11 = [new_node_position[0] - 1, new_node_position[1] - 1] 	# x-1, y-1
	neighbor_position_12 = [new_node_position[0] + 1, new_node_position[1] - 1] 	# x+1, y-1

	#################################################
	# case (b)
	#################################################

	# x-1 and x+1
	if neighbor_position_1 in taken_position and neighbor_position_2 in taken_position:
		# weight initialize				
		neighbor_position_1_index = functions.get_position_index(gmap, neighbor_position_1)	
		neighbor_position_2_index = functions.get_position_index(gmap, neighbor_position_2)	
				
		weight = []
				
		for i in range(len(gmap[neighbor_position_1_index]['weight_vector'])):
			weight.append((gmap[neighbor_position_1_index]['weight_vector'][i] + gmap[neighbor_position_2_index]['weight_vector'][i])/2)

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (b)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']

		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	# y-1 and y+1
	elif neighbor_position_3 in taken_position and neighbor_position_4 in taken_position:
		# weight initialize				
		neighbor_position_3_index = functions.get_position_index(gmap, neighbor_position_3)	
		neighbor_position_4_index = functions.get_position_index(gmap, neighbor_position_4)	
				
		weight = []
				
		for i in range(len(gmap[neighbor_position_3_index]['weight_vector'])):
			weight.append((gmap[neighbor_position_3_index]['weight_vector'][i] + gmap[neighbor_position_4_index]['weight_vector'][i])/2)

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (b)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	#################################################
	# case (a)
	#################################################

	# x-1 and x-2
	elif neighbor_position_1 in taken_position and neighbor_position_5 in taken_position: 		
		# weight initialize				
		neighbor_position_1_index = functions.get_position_index(gmap, neighbor_position_1)	
		neighbor_position_5_index = functions.get_position_index(gmap, neighbor_position_5)	
				
		weight = []
				
		for i in range(len(gmap[neighbor_position_1_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_1_index]['weight_vector'][i] - gmap[neighbor_position_5_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (a)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	# x+1 and x+2
	elif neighbor_position_2 in taken_position and neighbor_position_6 in taken_position: 		
		# weight initialize				
		neighbor_position_2_index = functions.get_position_index(gmap, neighbor_position_2)	
		neighbor_position_6_index = functions.get_position_index(gmap, neighbor_position_6)	
		
		weight = []
				
		for i in range(len(gmap[neighbor_position_2_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_2_index]['weight_vector'][i] - gmap[neighbor_position_6_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (a)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag
			
	# y-1 and y-2
	elif neighbor_position_3 in taken_position and neighbor_position_7 in taken_position: 		
		# weight initialize				
		neighbor_position_3_index = functions.get_position_index(gmap, neighbor_position_3)	
		neighbor_position_7_index = functions.get_position_index(gmap, neighbor_position_7)	
				
		weight = []
				
		for i in range(len(gmap[neighbor_position_3_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_3_index]['weight_vector'][i] - gmap[neighbor_position_7_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (a)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag
			
	# y+1 and y+2
	elif neighbor_position_4 in taken_position and neighbor_position_8 in taken_position: 		
		# weight initialize				
		neighbor_position_4_index = functions.get_position_index(gmap, neighbor_position_4)	
		neighbor_position_8_index = functions.get_position_index(gmap, neighbor_position_8)	
				
		weight = []
				
		for i in range(len(gmap[neighbor_position_4_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_4_index]['weight_vector'][i] - gmap[neighbor_position_8_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (a)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	#################################################
	# case (c)
	#################################################
			
	# x-1 and x-1,y+1
	elif neighbor_position_1 in taken_position and neighbor_position_9 in taken_position: 		
		# weight initialize				
		neighbor_position_1_index = functions.get_position_index(gmap, neighbor_position_1)	
		neighbor_position_9_index = functions.get_position_index(gmap, neighbor_position_9)	
				
		weight = []
				
		for i in range(len(gmap[neighbor_position_1_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_1_index]['weight_vector'][i] - gmap[neighbor_position_9_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (c)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	# x-1 and x-1,y-1
	elif neighbor_position_1 in taken_position and neighbor_position_11 in taken_position: 		
		# weight initialize				
		neighbor_position_1_index = functions.get_position_index(gmap, neighbor_position_1)	
		neighbor_position_11_index = functions.get_position_index(gmap, neighbor_position_11)	
		
		weight = []
				
		for i in range(len(gmap[neighbor_position_1_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_1_index]['weight_vector'][i] - gmap[neighbor_position_11_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (c)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	# x+1 and x+1,y+1
	elif neighbor_position_2 in taken_position and neighbor_position_10 in taken_position: 		
		# weight initialize				
		neighbor_position_2_index = functions.get_position_index(gmap, neighbor_position_2)	
		neighbor_position_10_index = functions.get_position_index(gmap, neighbor_position_10)	
		
		weight = []
				
		for i in range(len(gmap[neighbor_position_2_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_2_index]['weight_vector'][i] - gmap[neighbor_position_10_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (c)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	# x+1 and x+1,y-1
	elif neighbor_position_2 in taken_position and neighbor_position_12 in taken_position: 		
		# weight initialize				
		neighbor_position_2_index = functions.get_position_index(gmap, neighbor_position_2)	
		neighbor_position_12_index = functions.get_position_index(gmap, neighbor_position_12)	
		
		weight = []
				
		for i in range(len(gmap[neighbor_position_2_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_2_index]['weight_vector'][i] - gmap[neighbor_position_12_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (c)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	# y+1 and x-1,y+1
	elif neighbor_position_4 in taken_position and neighbor_position_9 in taken_position: 		
		# weight initialize				
		neighbor_position_4_index = functions.get_position_index(gmap, neighbor_position_4)	
		neighbor_position_9_index = functions.get_position_index(gmap, neighbor_position_9)	
		
		weight = []
				
		for i in range(len(gmap[neighbor_position_4_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_4_index]['weight_vector'][i] - gmap[neighbor_position_9_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (c)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	# y+1 and x+1,y+1
	elif neighbor_position_4 in taken_position and neighbor_position_10 in taken_position: 		
		# weight initialize				
		neighbor_position_4_index = functions.get_position_index(gmap, neighbor_position_4)	
		neighbor_position_10_index = functions.get_position_index(gmap, neighbor_position_10)	
		
		weight = []
				
		for i in range(len(gmap[neighbor_position_4_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_4_index]['weight_vector'][i] - gmap[neighbor_position_10_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (c)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	# y-1 and x-1,y-1
	elif neighbor_position_3 in taken_position and neighbor_position_11 in taken_position: 		
		# weight initialize				
		neighbor_position_3_index = functions.get_position_index(gmap, neighbor_position_3)	
		neighbor_position_11_index = functions.get_position_index(gmap, neighbor_position_11)	
				
		weight = []
				
		for i in range(len(gmap[neighbor_position_3_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_3_index]['weight_vector'][i] - gmap[neighbor_position_11_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (c)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	# y-1 and x+1,y-1
	elif neighbor_position_3 in taken_position and neighbor_position_12 in taken_position: 		
		# weight initialize				
		neighbor_position_3_index = functions.get_position_index(gmap, neighbor_position_3)	
		neighbor_position_12_index = functions.get_position_index(gmap, neighbor_position_12)	
			
		weight = []
				
		for i in range(len(gmap[neighbor_position_3_index]['weight_vector'])):
			weight.append(2 * gmap[neighbor_position_3_index]['weight_vector'][i] - gmap[neighbor_position_12_index]['weight_vector'][i])

		for i in range(len(weight)):
			if weight[i]>1:
				weight[i]=1
			if weight[i]<0:
				weight[i]=0

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (c)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	#################################################
	# case (d)
	#################################################
			
	# x-1 or x+1 or y-1 or y+1
	elif functions.check_number_of_neighbours(taken_position, [neighbor_position_1, neighbor_position_2, neighbor_position_3, neighbor_position_4]) == 1:

		weight = []
		for i in range(len(gmap[neighbor_position_3_index]['weight_vector'])):
			weight.append(0.5)

		new_node = {'position': new_node_position, 'weight_vector': weight, 'error_value': 0, 'hits': 0, 'is_boundary': 1, 'is_grow': 0}
		print 'add: case (d)', new_node['position'], 'error_value', new_node['error_value'], 'is_grow: ',new_node['is_grow'], 'is_boundary: ', new_node['is_boundary']
		
		gmap.append(new_node)				# add new nodes to the gmap
		taken_position.append(new_node['position'])	# update the taken position list
		gmap = functions.update_is_boundary(gmap, taken_position)	# update the 'is_boundary' flag

	else:
		print '\n#################################\nERROR: cannot calculate weight vectors for the new node!\n#################################\n'

	return gmap
